using System;
using System.Linq;

public class Program
{
    public static void Main()
    {
        var line1 = Console.ReadLine().Split();
        int n = int.Parse(line1[0]);
        int k = int.Parse(line1[1]);

        var moves = new (int dz, int dy)[n];
        for (int i = 0; i < n; i++)
        {
            var moveLine = Console.ReadLine().Split();
            moves[i] = (int.Parse(moveLine[0]), int.Parse(moveLine[1]));
        }

        long maxDistanceSquared = -1;
        int bestK = 0;
        int[] bestIndices = null;

        for (int i = 0; i < (1 << n); i++)
        {
            var indices = new System.Collections.Generic.List<int>();
            for (int j = 0; j < n; j++)
            {
                if ((i & (1 << j)) != 0)
                {
                    indices.Add(j + 1);
                }
            }

            if (indices.Count > k) continue;

            long currentZ = 0;
            long currentY = 0;

            foreach (int index in indices)
            {
                currentZ += moves[index - 1].dz;
                currentY += moves[index - 1].dy;
            }

            long currentDistanceSquared = currentZ * currentZ + currentY * currentY;

            if (currentDistanceSquared > maxDistanceSquared)
            {
                maxDistanceSquared = currentDistanceSquared;
                bestK = indices.Count;
                bestIndices = indices.ToArray();
            }
            else if (currentDistanceSquared == maxDistanceSquared)
            {
                if (indices.Count < bestK)
                {
                    bestK = indices.Count;
                    bestIndices = indices.ToArray();
                }
                else if (indices.Count == bestK)
                {
                    if (bestIndices == null || IsLexicographicallySmaller(indices.ToArray(), bestIndices))
                    {
                        bestIndices = indices.ToArray();
                    }
                }
            }
        }

        Console.WriteLine(bestK);
        Console.WriteLine(string.Join(" ", bestIndices));
    }

    private static bool IsLexicographicallySmaller(int[] arr1, int[] arr2)
    {
        int len = Math.Min(arr1.Length, arr2.Length);
        for (int i = 0; i < len; i++)
        {
            if (arr1[i] < arr2[i]) return true;
            if (arr1[i] > arr2[i]) return false;
        }
        return arr1.Length < arr2.Length;
    }
}